
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Interaction / Page"
	SimpleWait ( )
#ENDIF

Declare Sub Render_Page ( Page ( Any ) As Story_Page_Type )

Declare Function Navigate_Page ( Page ( Any ) As Story_Page_Type, C As String = "" ) As Long

Declare Sub Render_Text ( Page As Story_Page_Type, ByRef Dest As FB.Image Ptr, Textdata As String = "", Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF, HideSpecial As Long = 1, ByRef Source_Sheet As FB.Image Ptr = 0 )

Declare Sub CLS2 ( ByRef Source As FB.Image Ptr, Fill As Long = 0 )

Declare Sub Render_Scroll ( Page As Story_Page_Type, TextData As String = "", ByRef Disp As FB.Image Ptr, Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF )

Declare Function GamePercent ( Page ( Any ) As Story_Page_Type, PageLocation As Long = 0, ByRef Total As Long, ByRef Tally As Long, ByRef Turns As Long ) As String

Declare Sub GameGallery ( Page ( Any ) As Story_Page_Type )

Sub Render_Page ( Page ( Any ) As Story_Page_Type )

	If UBound( Page, 1 ) = -1 Then Exit Sub

	Dim as Long Index = 0
	
	Dim As String Caption = ""

	With Page ( PageLocation )

		For Index = 0 To UBound ( .Desc, 1 ) Step 1

			If Len ( Caption ) > 0 and Len ( .Desc ( Index ) .Text ) > 0 Then
			
				Caption &= " "
		
			End If
		
			Caption &= .Desc ( Index ) .Text

		Next Index

		Render_Scroll ( Page (  PageLocation ), Caption, .Layers ( Pg_Description ), 1, 1, RGBA ( 255, 255, 255, 255 ) )

		Caption = ""
	
		For Index = 0 To UBound ( .Options, 1 ) Step 1

			If Len ( .Options ( Index ) .Caption ) > 0 Then
		
				Select Case Sgn ( .Options ( Index ) .Req )
				Case 0
					
					If Len ( Caption ) > 0 and Len ( .Options ( Index ) .Caption ) > 0 Then
				
						Caption &= " "
		
					End If
				
					If Len ( .Options ( Index ) .Caption ) > 0 Then
					
						If .Options ( Index ) .Key = SP Then
							Caption &= "<SP>"
						Else
							Caption &= "<" & UCase ( .Options ( Index ) .Key ) & ">"
						End If
					
					
						Caption &= .Options ( Index ) .Caption
						
					End If

				case 1
				
					If ( Page (.Options ( Index ) .Req ) ) .History > 0 Then 
					
						If Len ( Caption ) > 0 and Len ( .Options ( Index ) .Caption ) > 0 Then
				
							Caption &= " "
					
						End If
			
						If Len ( .Options ( Index ) .Caption ) > 0 Then
					
							If .Options ( Index ) .Key = SP Then
								Caption &= "<SP>"
							Else
								Caption &= "<" & UCase ( .Options ( Index ) .Key ) & ">"
							End If
			
							Caption &= .Options ( Index ) .Caption
						
						End If
				
					End If
				
				case -1
				
					If Page ( Abs ( .Options ( Index ) .Req ) ) .History = 0 Then 
					
						If Len ( Caption ) > 0 and Len ( .Options ( Index ) .Caption ) > 0 Then
				
							Caption &= " "
		
						End If

						If Len ( .Options ( Index ) .Caption ) > 0 Then
						
							If .Options ( Index ) .Key = SP Then
								Caption &= "<SP>"
							Else
								Caption &= "<" & UCase ( .Options ( Index ) .Key ) & ">"
							End If
			
							Caption &= .Options ( Index ) .Caption
						
						End If
					
					End If

				End Select

			End If
		
		Next Index
	
		Render_Text Page ( PageLocation ), .Layers ( Pg_Caption ), .Caption, ( ( .Layers ( Pg_Caption ) -> Width - Len ( .Caption ) Shl 3 ) Shr 3 ) \ 2 + 1, 1, RGBA ( 255, 255, 255, 255 )

		Render_Scroll ( Page ( PageLocation ), Caption, .Layers ( Pg_Options ), 1, 1, RGBA ( 255, 255, 255, 255 ) )

	End With

	Exit Sub

End Sub 

Function Navigate_Page ( Page ( Any ) As Story_Page_Type, C As String = "" ) As Long

	Dim as Long Index = 0

	With Page ( PageLocation )

		If C = "" Then
		
			If .History = 0 Then
				.History += 1
			End If
		
			Return .Index
	
		End If
		
		For Index = 1 To 4 Step 1

			Select Case Sgn ( .Options ( Index ) .Req )
			Case 0
			
				If LCase ( C ) = LCase ( .Options ( Index ) .Key ) Then
					
					If Setting_Turn Then
						.History += 1
					End If
					Return .Options ( Index ) .Dest
		
				End If
				
			case 1
				
				If Page ( .Options ( Index ) .Req ) .History > 0 Then 
					
					If LCase ( C ) = LCase ( .Options ( Index ) .Key ) Then
					
						If Setting_Turn Then
							.History += 1
						End If
						Return .Options ( Index ) .Dest

					End If
				
				End If
				
			case -1
				
				If Page ( Abs ( .Options ( Index ) .Req ) ) .History = 0 Then 
					
					If LCase ( C ) = LCase ( .Options ( Index ) .Key ) Then
					
						If Setting_Turn Then
						.History += 1
						End If
						Return .Options ( Index ) .Dest
						
					End If
				
					
				End If

			End Select
		
		Next Index
	
		Navigate_Page = .Index

	End With
	
End Function

Sub Render_Text ( Page As Story_Page_Type, ByRef Dest As FB.Image Ptr, Textdata As String = "", Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF, HideSpecial As Long = 1, ByRef Source_Sheet As FB.Image Ptr = 0 )
	
	Dim As Long TempSheet = 0
	
	If Source_Sheet = 0 Then
		Source_Sheet = LoadRGBAFile ( _constIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\Fonts\Mishap22.png" )
		TempSheet = 1
	End If

	Dim As Long sX = 8, sY = 8
	
	sX = Source_Sheet -> Width \ 16
	sY = Source_Sheet -> Height \ 16
	
	Dim As Long Xo = Col, Yo = Row , Zo = 0

	Dim As Long Xa = 0, Ya = 0, Za = 0

	Yo = ( Row - 1 ) * sY

	For Zo = 1 To Len ( TextData ) Step 1

		Za = Asc ( Mid ( TextData, Zo, 1 ) )

		Xo = ( Col + Zo - 1 ) * sX

		Xa = ( Za Mod 16 ) * sX

		Ya = ( Za \ 16 ) * sY

		Select Case HideSpecial
		Case 0
		
			put Dest, ( Xo, Yo ), Source_Sheet, ( Xa, Ya ) - step ( sX - 1, sY - 1 ), Alpha
			
		Case Else
		
			Select Case Za
			Case 32
			Case Else
			
				put Dest, ( Xo, Yo ), Source_Sheet, ( Xa, Ya ) - step ( sX - 1, sY - 1 ), Alpha
				
			End Select
						
		End Select

	Next Zo

	If TempSheet = 1 Then
		Source_Sheet = ImageDestroy2 ( Source_Sheet )
	End If

End Sub

Sub CLS2 ( ByRef Source As FB.Image Ptr, Fill As Long = 0 )

	Line Source, ( 0, 0 ) - ( Source -> Width - 1, Source -> Height - 1 ), Fill, BF

End Sub

Sub Render_Scroll ( Page As Story_Page_Type, TextData As String = "", ByRef Disp As FB.Image Ptr, Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF )

	Dim As String OutBuffer = "", ReserveBuffer = ""
		
	OutBuffer = ""
	ReserveBuffer = TextData
	
	Dim As Long W = ( Disp -> Width Shr 3 ) + 1, H = ( Disp -> Height Shr 3 ) + 1
		
	ReserveBuffer = Str_Replace ( Space ( 2 ), SP, ReserveBuffer )

	Do While Len ( ReserveBuffer ) > 0
	
		OutBuffer &= Prefix ( CRLF, ReserveBuffer )
		ReserveBuffer = Suffix ( CRLF, ReserveBuffer )
		
		Trim ( OutBuffer )
		
		Do While Len ( OutBuffer ) >= W
		
			Select Case StrPos ( SP, OutBuffer )
			Case Is > 0
			
				ReserveBuffer = Ext_Suffix ( SP, OutBuffer ) & SP & ReserveBuffer
				OutBuffer = Ext_Prefix ( SP, OutBuffer )
			
			Case 0
			
				ReserveBuffer = "-" & Mid ( OutBuffer, W + 1 ) & ReserveBuffer
				OutBuffer = Left ( OutBuffer, W )
			
			End Select
			
		Loop
		
		Col = ( W - Len ( OutBuffer ) ) \ 2

		Render_Text Page, Disp, OutBuffer, Col, Row, Stroke_Color
		
		OutBuffer = ""
		
		Row += 1
		
	Loop
	
End Sub

Function GamePercent ( Page ( Any ) As Story_Page_Type, PageLocation As Long = 0, ByRef Total As Long, ByRef Tally As Long, ByRef Turns As Long ) As String
	
	Dim As Long Index = 0
	
	Total = 0
	Index = 0
	Tally = 0
	Turns = 0
	
	Dim As String Score = ""
	
	Total = UBound ( Page, 1 ) - LBound ( Page, 1 ) + 1
	
	For Index = 0 To Ubound ( Page, 1 ) Step 1
		
		If PageLocation = 0 Then
		
			'[!]'Clear_Page ( Page ( PageLocation ) )
	
			Page ( Index ) .History = 0
		
		End If
		
		If Page ( Index ) .History > 0 Then
			Tally += 1
			Turns += Page ( Index ) .History
		End If
		
	Next Index
	
	Score = Right ( String ( 5, "0" ) & Str ( Tally * 10000 \ Total ), 5 )
	
	Score = Left ( Score, 3 ) & "." & Right ( Score, 2 ) & "%"
	
	Return Score
	
End Function

Sub GameGallery ( Page ( Any ) As Story_Page_Type )
	
	Dim As FB.Image Ptr Intermediary 
	
	If Page ( 0 ) .Layers ( Pg_Gallery ) <> 0 Then
		ImageDestroy2 ( Page ( PageLocation ) .Layers ( Pg_Gallery ) )
	End If
	
	Page ( 0 ) .Layers ( Pg_Gallery ) = ImageCreate ( Page ( PageLocation ) .Layers ( Pg_Intermediary ) -> Width, Page ( 0 ) .Layers ( Pg_Intermediary ) -> Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Dim As Long Index = 0, Xo = 0, Yo = 0
	
	If Page( PageLocation ) .Visited = 0 Then
		If PageLocation > 0 Then
			Turns += 1
		End If
		Page( PageLocation ) .Visited = Turns
	End If
	
	For Index = 0 To Ubound ( Page, 1 ) Step 1
		
		If PageLocation <> Index Then
			If Page ( Index ) .History = 0 Then Continue For
		End If
		
		If Page ( Index ) .Layers ( Pg_Thumbnail ) = 0 Then
		
			Page ( Index ) .Layers ( Pg_Thumbnail ) = ImageCreate ( 24, 24, RGBA ( 0, 0, 0, 0 ), 32 )

			Intermediary = ImageCreate ( 24, 24, RGBA ( 0, 0, 0, 0 ), 32 )	

			Gfx_Buffer_Stretch_Aspect ( Page ( PageLocation ) .Layers ( Pg_Illustration ), Intermediary )
		
			Gfx_Buffer_Inlay Intermediary, Page ( Index ) .Layers ( Pg_Thumbnail )
			
			Gfx_Buffer_Alpha ( Page ( PageLocation ) .Layers ( Pg_Thumbnail ), 96 )

		End If
		
		Xo = ( ( Page( Index ) .Visited ) Mod ( Page ( PageLocation ) .Layers ( Pg_Gallery ) -> Width \ 24 ) ) * 24
			
		Yo = ( ( Page( Index ) .Visited ) \ ( Page ( PageLocation ) .Layers ( Pg_Gallery ) -> Width \ 24 ) ) * 24
				
		Put Page ( 0 ) .Layers ( Pg_Gallery ), ( Xo, Yo ), Page ( Index ) .Layers ( Pg_Thumbnail ), Alpha
				
	Next Index
	
End Sub

